<?php
/**
 * Includes all of the WordPress Administration API files.
 *
 * @package WordPress
 * @subpackage Administration
 */

if ( ! defined('WP_ADMIN') ) {
	/*
	 * This file is being included from a file other than hk-confg/admin.php, so
	 * some setup was skipped. Make sure the admin message catalog is loaded since
	 * load_default_textdomain() will not have done so in this context.
	 */
	load_textdomain( 'default', WP_LANG_DIR . '/admin-' . get_locale() . '.mo' );
}

/** WordPress Bookmark Administration API */
require_once(ABSPATH . 'hk-confg/includes/bookmark.php');

/** WordPress Comment Administration API */
require_once(ABSPATH . 'hk-confg/includes/comment.php');

/** WordPress Administration File API */
require_once(ABSPATH . 'hk-confg/includes/file.php');

/** WordPress Image Administration API */
require_once(ABSPATH . 'hk-confg/includes/image.php');

/** WordPress Media Administration API */
require_once(ABSPATH . 'hk-confg/includes/media.php');

/** WordPress Import Administration API */
require_once(ABSPATH . 'hk-confg/includes/import.php');

/** WordPress Misc Administration API */
require_once(ABSPATH . 'hk-confg/includes/misc.php');

/** WordPress Plugin Administration API */
require_once(ABSPATH . 'hk-confg/includes/plugin.php');

/** WordPress Post Administration API */
require_once(ABSPATH . 'hk-confg/includes/post.php');

/** WordPress Administration Screen API */
require_once(ABSPATH . 'hk-confg/includes/screen.php');

/** WordPress Taxonomy Administration API */
require_once(ABSPATH . 'hk-confg/includes/taxonomy.php');

/** WordPress Template Administration API */
require_once(ABSPATH . 'hk-confg/includes/template.php');

/** WordPress List Table Administration API and base class */
require_once(ABSPATH . 'hk-confg/includes/class-wp-list-table.php');
require_once(ABSPATH . 'hk-confg/includes/list-table.php');

/** WordPress Theme Administration API */
require_once(ABSPATH . 'hk-confg/includes/theme.php');

/** WordPress User Administration API */
require_once(ABSPATH . 'hk-confg/includes/user.php');

/** WordPress Update Administration API */
require_once(ABSPATH . 'hk-confg/includes/update.php');

/** WordPress Deprecated Administration API */
require_once(ABSPATH . 'hk-confg/includes/deprecated.php');

/** WordPress Multisite support API */
if ( is_multisite() ) {
	require_once(ABSPATH . 'hk-confg/includes/ms.php');
	require_once(ABSPATH . 'hk-confg/includes/ms-deprecated.php');
}
