<?php
/**
 * WordPress core upgrade functionality.
 *
 * @package WordPress
 * @subpackage Administration
 * @since 2.7.0
 */

/**
 * Stores files to be deleted.
 *
 * @since 2.7.0
 * @global array $_old_files
 * @var array
 * @name $_old_files
 */
global $_old_files;

$_old_files = array(
// 2.0
'hk-confg/import-b2.php',
'hk-confg/import-blogger.php',
'hk-confg/import-greymatter.php',
'hk-confg/import-livejournal.php',
'hk-confg/import-mt.php',
'hk-confg/import-rss.php',
'hk-confg/import-textpattern.php',
'hk-confg/quicktags.js',
'wp-images/fade-butt.png',
'wp-images/get-firefox.png',
'wp-images/header-shadow.png',
'wp-images/smilies',
'wp-images/wp-small.png',
'wp-images/wpminilogo.png',
'wp.php',
// 2.0.8
'hk-icerilen/js/tinymce/plugins/inlinepopups/readme.txt',
// 2.1
'hk-confg/edit-form-ajax-cat.php',
'hk-confg/execute-pings.php',
'hk-confg/inline-uploading.php',
'hk-confg/link-categories.php',
'hk-confg/list-manipulation.js',
'hk-confg/list-manipulation.php',
'hk-icerilen/comment-functions.php',
'hk-icerilen/feed-functions.php',
'hk-icerilen/functions-compat.php',
'hk-icerilen/functions-formatting.php',
'hk-icerilen/functions-post.php',
'hk-icerilen/js/dbx-key.js',
'hk-icerilen/js/tinymce/plugins/autosave/langs/cs.js',
'hk-icerilen/js/tinymce/plugins/autosave/langs/sv.js',
'hk-icerilen/links.php',
'hk-icerilen/pluggable-functions.php',
'hk-icerilen/template-functions-author.php',
'hk-icerilen/template-functions-category.php',
'hk-icerilen/template-functions-general.php',
'hk-icerilen/template-functions-links.php',
'hk-icerilen/template-functions-post.php',
'hk-icerilen/wp-l10n.php',
// 2.2
'hk-confg/cat-js.php',
'hk-confg/import/b2.php',
'hk-icerilen/js/autosave-js.php',
'hk-icerilen/js/list-manipulation-js.php',
'hk-icerilen/js/wp-ajax-js.php',
// 2.3
'hk-confg/admin-db.php',
'hk-confg/cat.js',
'hk-confg/categories.js',
'hk-confg/custom-fields.js',
'hk-confg/dbx-admin-key.js',
'hk-confg/edit-comments.js',
'hk-confg/install-rtl.css',
'hk-confg/install.css',
'hk-confg/upgrade-schema.php',
'hk-confg/upload-functions.php',
'hk-confg/upload-rtl.css',
'hk-confg/upload.css',
'hk-confg/upload.js',
'hk-confg/users.js',
'hk-confg/widgets-rtl.css',
'hk-confg/widgets.css',
'hk-confg/xfn.js',
'hk-icerilen/js/tinymce/license.html',
// 2.5
'hk-confg/css/upload.css',
'hk-confg/images/box-bg-left.gif',
'hk-confg/images/box-bg-right.gif',
'hk-confg/images/box-bg.gif',
'hk-confg/images/box-butt-left.gif',
'hk-confg/images/box-butt-right.gif',
'hk-confg/images/box-butt.gif',
'hk-confg/images/box-head-left.gif',
'hk-confg/images/box-head-right.gif',
'hk-confg/images/box-head.gif',
'hk-confg/images/heading-bg.gif',
'hk-confg/images/login-bkg-bottom.gif',
'hk-confg/images/login-bkg-tile.gif',
'hk-confg/images/notice.gif',
'hk-confg/images/toggle.gif',
'hk-confg/includes/upload.php',
'hk-confg/js/dbx-admin-key.js',
'hk-confg/js/link-cat.js',
'hk-confg/profile-update.php',
'hk-confg/templates.php',
'hk-icerilen/images/wlw/WpComments.png',
'hk-icerilen/images/wlw/WpIcon.png',
'hk-icerilen/images/wlw/WpWatermark.png',
'hk-icerilen/js/dbx.js',
'hk-icerilen/js/fat.js',
'hk-icerilen/js/list-manipulation.js',
'hk-icerilen/js/tinymce/langs/en.js',
'hk-icerilen/js/tinymce/plugins/autosave/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/autosave/langs',
'hk-icerilen/js/tinymce/plugins/directionality/images',
'hk-icerilen/js/tinymce/plugins/directionality/langs',
'hk-icerilen/js/tinymce/plugins/inlinepopups/css',
'hk-icerilen/js/tinymce/plugins/inlinepopups/images',
'hk-icerilen/js/tinymce/plugins/inlinepopups/jscripts',
'hk-icerilen/js/tinymce/plugins/paste/images',
'hk-icerilen/js/tinymce/plugins/paste/jscripts',
'hk-icerilen/js/tinymce/plugins/paste/langs',
'hk-icerilen/js/tinymce/plugins/spellchecker/classes/HttpClient.class.php',
'hk-icerilen/js/tinymce/plugins/spellchecker/classes/TinyGoogleSpell.class.php',
'hk-icerilen/js/tinymce/plugins/spellchecker/classes/TinyPspell.class.php',
'hk-icerilen/js/tinymce/plugins/spellchecker/classes/TinyPspellShell.class.php',
'hk-icerilen/js/tinymce/plugins/spellchecker/css/spellchecker.css',
'hk-icerilen/js/tinymce/plugins/spellchecker/images',
'hk-icerilen/js/tinymce/plugins/spellchecker/langs',
'hk-icerilen/js/tinymce/plugins/spellchecker/tinyspell.php',
'hk-icerilen/js/tinymce/plugins/wordpress/images',
'hk-icerilen/js/tinymce/plugins/wordpress/langs',
'hk-icerilen/js/tinymce/plugins/wordpress/wordpress.css',
'hk-icerilen/js/tinymce/plugins/wphelp',
'hk-icerilen/js/tinymce/themes/advanced/css',
'hk-icerilen/js/tinymce/themes/advanced/images',
'hk-icerilen/js/tinymce/themes/advanced/jscripts',
'hk-icerilen/js/tinymce/themes/advanced/langs',
// 2.5.1
'hk-icerilen/js/tinymce/tiny_mce_gzip.php',
// 2.6
'hk-confg/bookmarklet.php',
'hk-icerilen/js/jquery/jquery.dimensions.min.js',
'hk-icerilen/js/tinymce/plugins/wordpress/popups.css',
'hk-icerilen/js/wp-ajax.js',
// 2.7
'hk-confg/css/press-this-ie-rtl.css',
'hk-confg/css/press-this-ie.css',
'hk-confg/css/upload-rtl.css',
'hk-confg/edit-form.php',
'hk-confg/images/comment-pill.gif',
'hk-confg/images/comment-stalk-classic.gif',
'hk-confg/images/comment-stalk-fresh.gif',
'hk-confg/images/comment-stalk-rtl.gif',
'hk-confg/images/del.png',
'hk-confg/images/gear.png',
'hk-confg/images/media-button-gallery.gif',
'hk-confg/images/media-buttons.gif',
'hk-confg/images/postbox-bg.gif',
'hk-confg/images/tab.png',
'hk-confg/images/tail.gif',
'hk-confg/js/forms.js',
'hk-confg/js/upload.js',
'hk-confg/link-import.php',
'hk-icerilen/images/audio.png',
'hk-icerilen/images/css.png',
'hk-icerilen/images/default.png',
'hk-icerilen/images/doc.png',
'hk-icerilen/images/exe.png',
'hk-icerilen/images/html.png',
'hk-icerilen/images/js.png',
'hk-icerilen/images/pdf.png',
'hk-icerilen/images/swf.png',
'hk-icerilen/images/tar.png',
'hk-icerilen/images/text.png',
'hk-icerilen/images/video.png',
'hk-icerilen/images/zip.png',
'hk-icerilen/js/tinymce/tiny_mce_config.php',
'hk-icerilen/js/tinymce/tiny_mce_ext.js',
// 2.8
'hk-confg/js/users.js',
'hk-icerilen/js/swfupload/plugins/swfupload.documentready.js',
'hk-icerilen/js/swfupload/plugins/swfupload.graceful_degradation.js',
'hk-icerilen/js/swfupload/swfupload_f9.swf',
'hk-icerilen/js/tinymce/plugins/autosave',
'hk-icerilen/js/tinymce/plugins/paste/css',
'hk-icerilen/js/tinymce/utils/mclayer.js',
'hk-icerilen/js/tinymce/wordpress.css',
// 2.8.5
'hk-confg/import/btt.php',
'hk-confg/import/jkw.php',
// 2.9
'hk-confg/js/page.dev.js',
'hk-confg/js/page.js',
'hk-confg/js/set-post-thumbnail-handler.dev.js',
'hk-confg/js/set-post-thumbnail-handler.js',
'hk-confg/js/slug.dev.js',
'hk-confg/js/slug.js',
'hk-icerilen/gettext.php',
'hk-icerilen/js/tinymce/plugins/wordpress/js',
'hk-icerilen/streams.php',
// MU
'README.txt',
'htaccess.dist',
'index-install.php',
'hk-confg/css/mu-rtl.css',
'hk-confg/css/mu.css',
'hk-confg/images/site-admin.png',
'hk-confg/includes/mu.php',
'hk-confg/wpmu-admin.php',
'hk-confg/wpmu-blogs.php',
'hk-confg/wpmu-edit.php',
'hk-confg/wpmu-options.php',
'hk-confg/wpmu-themes.php',
'hk-confg/wpmu-upgrade-site.php',
'hk-confg/wpmu-users.php',
'hk-icerilen/images/wordpress-mu.png',
'hk-icerilen/wpmu-default-filters.php',
'hk-icerilen/wpmu-functions.php',
'wpmu-settings.php',
// 3.0
'hk-confg/categories.php',
'hk-confg/edit-category-form.php',
'hk-confg/edit-page-form.php',
'hk-confg/edit-pages.php',
'hk-confg/images/admin-header-footer.png',
'hk-confg/images/browse-happy.gif',
'hk-confg/images/ico-add.png',
'hk-confg/images/ico-close.png',
'hk-confg/images/ico-edit.png',
'hk-confg/images/ico-viewpage.png',
'hk-confg/images/fav-top.png',
'hk-confg/images/screen-options-left.gif',
'hk-confg/images/wp-logo-vs.gif',
'hk-confg/images/wp-logo.gif',
'hk-confg/import',
'hk-confg/js/wp-gears.dev.js',
'hk-confg/js/wp-gears.js',
'hk-confg/options-misc.php',
'hk-confg/page-new.php',
'hk-confg/page.php',
'hk-confg/rtl.css',
'hk-confg/rtl.dev.css',
'hk-confg/update-links.php',
'hk-confg/hk-confg.css',
'hk-confg/hk-confg.dev.css',
'hk-icerilen/js/codepress',
'hk-icerilen/js/codepress/engines/khtml.js',
'hk-icerilen/js/codepress/engines/older.js',
'hk-icerilen/js/jquery/autocomplete.dev.js',
'hk-icerilen/js/jquery/autocomplete.js',
'hk-icerilen/js/jquery/interface.js',
'hk-icerilen/js/scriptaculous/prototype.js',
'hk-icerilen/js/tinymce/wp-tinymce.js',
// 3.1
'hk-confg/edit-attachment-rows.php',
'hk-confg/edit-link-categories.php',
'hk-confg/edit-link-category-form.php',
'hk-confg/edit-post-rows.php',
'hk-confg/images/button-grad-active-vs.png',
'hk-confg/images/button-grad-vs.png',
'hk-confg/images/fav-arrow-vs-rtl.gif',
'hk-confg/images/fav-arrow-vs.gif',
'hk-confg/images/fav-top-vs.gif',
'hk-confg/images/list-vs.png',
'hk-confg/images/screen-options-right-up.gif',
'hk-confg/images/screen-options-right.gif',
'hk-confg/images/visit-site-button-grad-vs.gif',
'hk-confg/images/visit-site-button-grad.gif',
'hk-confg/link-category.php',
'hk-confg/sidebar.php',
'hk-icerilen/classes.php',
'hk-icerilen/js/tinymce/blank.htm',
'hk-icerilen/js/tinymce/plugins/media/css/content.css',
'hk-icerilen/js/tinymce/plugins/media/img',
'hk-icerilen/js/tinymce/plugins/safari',
// 3.2
'hk-confg/images/logo-login.gif',
'hk-confg/images/star.gif',
'hk-confg/js/list-table.dev.js',
'hk-confg/js/list-table.js',
'hk-icerilen/default-embeds.php',
'hk-icerilen/js/tinymce/plugins/wordpress/img/help.gif',
'hk-icerilen/js/tinymce/plugins/wordpress/img/more.gif',
'hk-icerilen/js/tinymce/plugins/wordpress/img/toolbars.gif',
'hk-icerilen/js/tinymce/themes/advanced/img/fm.gif',
'hk-icerilen/js/tinymce/themes/advanced/img/sflogo.png',
// 3.3
'hk-confg/css/colors-classic-rtl.css',
'hk-confg/css/colors-classic-rtl.dev.css',
'hk-confg/css/colors-fresh-rtl.css',
'hk-confg/css/colors-fresh-rtl.dev.css',
'hk-confg/css/dashboard-rtl.dev.css',
'hk-confg/css/dashboard.dev.css',
'hk-confg/css/global-rtl.css',
'hk-confg/css/global-rtl.dev.css',
'hk-confg/css/global.css',
'hk-confg/css/global.dev.css',
'hk-confg/css/install-rtl.dev.css',
'hk-confg/css/login-rtl.dev.css',
'hk-confg/css/login.dev.css',
'hk-confg/css/ms.css',
'hk-confg/css/ms.dev.css',
'hk-confg/css/nav-menu-rtl.css',
'hk-confg/css/nav-menu-rtl.dev.css',
'hk-confg/css/nav-menu.css',
'hk-confg/css/nav-menu.dev.css',
'hk-confg/css/plugin-install-rtl.css',
'hk-confg/css/plugin-install-rtl.dev.css',
'hk-confg/css/plugin-install.css',
'hk-confg/css/plugin-install.dev.css',
'hk-confg/css/press-this-rtl.dev.css',
'hk-confg/css/press-this.dev.css',
'hk-confg/css/theme-editor-rtl.css',
'hk-confg/css/theme-editor-rtl.dev.css',
'hk-confg/css/theme-editor.css',
'hk-confg/css/theme-editor.dev.css',
'hk-confg/css/theme-install-rtl.css',
'hk-confg/css/theme-install-rtl.dev.css',
'hk-confg/css/theme-install.css',
'hk-confg/css/theme-install.dev.css',
'hk-confg/css/widgets-rtl.dev.css',
'hk-confg/css/widgets.dev.css',
'hk-confg/includes/internal-linking.php',
'hk-icerilen/images/admin-bar-sprite-rtl.png',
'hk-icerilen/js/jquery/ui.button.js',
'hk-icerilen/js/jquery/ui.core.js',
'hk-icerilen/js/jquery/ui.dialog.js',
'hk-icerilen/js/jquery/ui.draggable.js',
'hk-icerilen/js/jquery/ui.droppable.js',
'hk-icerilen/js/jquery/ui.mouse.js',
'hk-icerilen/js/jquery/ui.position.js',
'hk-icerilen/js/jquery/ui.resizable.js',
'hk-icerilen/js/jquery/ui.selectable.js',
'hk-icerilen/js/jquery/ui.sortable.js',
'hk-icerilen/js/jquery/ui.tabs.js',
'hk-icerilen/js/jquery/ui.widget.js',
'hk-icerilen/js/l10n.dev.js',
'hk-icerilen/js/l10n.js',
'hk-icerilen/js/tinymce/plugins/wplink/css',
'hk-icerilen/js/tinymce/plugins/wplink/img',
'hk-icerilen/js/tinymce/plugins/wplink/js',
'hk-icerilen/js/tinymce/themes/advanced/img/wpicons.png',
'hk-icerilen/js/tinymce/themes/advanced/skins/wp_theme/img/butt2.png',
'hk-icerilen/js/tinymce/themes/advanced/skins/wp_theme/img/button_bg.png',
'hk-icerilen/js/tinymce/themes/advanced/skins/wp_theme/img/down_arrow.gif',
'hk-icerilen/js/tinymce/themes/advanced/skins/wp_theme/img/fade-butt.png',
'hk-icerilen/js/tinymce/themes/advanced/skins/wp_theme/img/separator.gif',
// Don't delete, yet: 'wp-rss.php',
// Don't delete, yet: 'wp-rdf.php',
// Don't delete, yet: 'wp-rss2.php',
// Don't delete, yet: 'wp-commentsrss2.php',
// Don't delete, yet: 'wp-atom.php',
// Don't delete, yet: 'wp-feed.php',
// 3.4
'hk-confg/images/gray-star.png',
'hk-confg/images/logo-login.png',
'hk-confg/images/star.png',
'hk-confg/index-extra.php',
'hk-confg/network/index-extra.php',
'hk-confg/user/index-extra.php',
'hk-confg/images/screenshots/admin-flyouts.png',
'hk-confg/images/screenshots/coediting.png',
'hk-confg/images/screenshots/drag-and-drop.png',
'hk-confg/images/screenshots/help-screen.png',
'hk-confg/images/screenshots/media-icon.png',
'hk-confg/images/screenshots/new-feature-pointer.png',
'hk-confg/images/screenshots/welcome-screen.png',
'hk-icerilen/css/editor-buttons.css',
'hk-icerilen/css/editor-buttons.dev.css',
'hk-icerilen/js/tinymce/plugins/paste/blank.htm',
'hk-icerilen/js/tinymce/plugins/wordpress/css',
'hk-icerilen/js/tinymce/plugins/wordpress/editor_plugin.dev.js',
'hk-icerilen/js/tinymce/plugins/wordpress/img/embedded.png',
'hk-icerilen/js/tinymce/plugins/wordpress/img/more_bug.gif',
'hk-icerilen/js/tinymce/plugins/wordpress/img/page_bug.gif',
'hk-icerilen/js/tinymce/plugins/wpdialogs/editor_plugin.dev.js',
'hk-icerilen/js/tinymce/plugins/wpeditimage/css/editimage-rtl.css',
'hk-icerilen/js/tinymce/plugins/wpeditimage/editor_plugin.dev.js',
'hk-icerilen/js/tinymce/plugins/wpfullscreen/editor_plugin.dev.js',
'hk-icerilen/js/tinymce/plugins/wpgallery/editor_plugin.dev.js',
'hk-icerilen/js/tinymce/plugins/wpgallery/img/gallery.png',
'hk-icerilen/js/tinymce/plugins/wplink/editor_plugin.dev.js',
// Don't delete, yet: 'wp-pass.php',
// Don't delete, yet: 'wp-register.php',
// 3.5
'hk-confg/gears-manifest.php',
'hk-confg/includes/manifest.php',
'hk-confg/images/archive-link.png',
'hk-confg/images/blue-grad.png',
'hk-confg/images/button-grad-active.png',
'hk-confg/images/button-grad.png',
'hk-confg/images/ed-bg-vs.gif',
'hk-confg/images/ed-bg.gif',
'hk-confg/images/fade-butt.png',
'hk-confg/images/fav-arrow-rtl.gif',
'hk-confg/images/fav-arrow.gif',
'hk-confg/images/fav-vs.png',
'hk-confg/images/fav.png',
'hk-confg/images/gray-grad.png',
'hk-confg/images/loading-publish.gif',
'hk-confg/images/logo-ghost.png',
'hk-confg/images/logo.gif',
'hk-confg/images/menu-arrow-frame-rtl.png',
'hk-confg/images/menu-arrow-frame.png',
'hk-confg/images/menu-arrows.gif',
'hk-confg/images/menu-bits-rtl-vs.gif',
'hk-confg/images/menu-bits-rtl.gif',
'hk-confg/images/menu-bits-vs.gif',
'hk-confg/images/menu-bits.gif',
'hk-confg/images/menu-dark-rtl-vs.gif',
'hk-confg/images/menu-dark-rtl.gif',
'hk-confg/images/menu-dark-vs.gif',
'hk-confg/images/menu-dark.gif',
'hk-confg/images/required.gif',
'hk-confg/images/screen-options-toggle-vs.gif',
'hk-confg/images/screen-options-toggle.gif',
'hk-confg/images/toggle-arrow-rtl.gif',
'hk-confg/images/toggle-arrow.gif',
'hk-confg/images/upload-classic.png',
'hk-confg/images/upload-fresh.png',
'hk-confg/images/white-grad-active.png',
'hk-confg/images/white-grad.png',
'hk-confg/images/widgets-arrow-vs.gif',
'hk-confg/images/widgets-arrow.gif',
'hk-confg/images/wpspin_dark.gif',
'hk-icerilen/images/upload.png',
'hk-icerilen/js/prototype.js',
'hk-icerilen/js/scriptaculous',
'hk-confg/css/hk-confg-rtl.dev.css',
'hk-confg/css/hk-confg.dev.css',
'hk-confg/css/media-rtl.dev.css',
'hk-confg/css/media.dev.css',
'hk-confg/css/colors-classic.dev.css',
'hk-confg/css/customize-controls-rtl.dev.css',
'hk-confg/css/customize-controls.dev.css',
'hk-confg/css/ie-rtl.dev.css',
'hk-confg/css/ie.dev.css',
'hk-confg/css/install.dev.css',
'hk-confg/css/colors-fresh.dev.css',
'hk-icerilen/js/customize-base.dev.js',
'hk-icerilen/js/json2.dev.js',
'hk-icerilen/js/comment-reply.dev.js',
'hk-icerilen/js/customize-preview.dev.js',
'hk-icerilen/js/wplink.dev.js',
'hk-icerilen/js/tw-sack.dev.js',
'hk-icerilen/js/wp-list-revisions.dev.js',
'hk-icerilen/js/autosave.dev.js',
'hk-icerilen/js/admin-bar.dev.js',
'hk-icerilen/js/quicktags.dev.js',
'hk-icerilen/js/wp-ajax-response.dev.js',
'hk-icerilen/js/wp-pointer.dev.js',
'hk-icerilen/js/hoverIntent.dev.js',
'hk-icerilen/js/colorpicker.dev.js',
'hk-icerilen/js/wp-lists.dev.js',
'hk-icerilen/js/customize-loader.dev.js',
'hk-icerilen/js/jquery/jquery.table-hotkeys.dev.js',
'hk-icerilen/js/jquery/jquery.color.dev.js',
'hk-icerilen/js/jquery/jquery.color.js',
'hk-icerilen/js/jquery/jquery.hotkeys.dev.js',
'hk-icerilen/js/jquery/jquery.form.dev.js',
'hk-icerilen/js/jquery/suggest.dev.js',
'hk-confg/js/xfn.dev.js',
'hk-confg/js/set-post-thumbnail.dev.js',
'hk-confg/js/comment.dev.js',
'hk-confg/js/theme.dev.js',
'hk-confg/js/cat.dev.js',
'hk-confg/js/password-strength-meter.dev.js',
'hk-confg/js/user-profile.dev.js',
'hk-confg/js/theme-preview.dev.js',
'hk-confg/js/post.dev.js',
'hk-confg/js/media-upload.dev.js',
'hk-confg/js/word-count.dev.js',
'hk-confg/js/plugin-install.dev.js',
'hk-confg/js/edit-comments.dev.js',
'hk-confg/js/media-gallery.dev.js',
'hk-confg/js/custom-fields.dev.js',
'hk-confg/js/custom-background.dev.js',
'hk-confg/js/common.dev.js',
'hk-confg/js/inline-edit-tax.dev.js',
'hk-confg/js/gallery.dev.js',
'hk-confg/js/utils.dev.js',
'hk-confg/js/widgets.dev.js',
'hk-confg/js/wp-fullscreen.dev.js',
'hk-confg/js/nav-menu.dev.js',
'hk-confg/js/dashboard.dev.js',
'hk-confg/js/link.dev.js',
'hk-confg/js/user-suggest.dev.js',
'hk-confg/js/postbox.dev.js',
'hk-confg/js/tags.dev.js',
'hk-confg/js/image-edit.dev.js',
'hk-confg/js/media.dev.js',
'hk-confg/js/customize-controls.dev.js',
'hk-confg/js/inline-edit-post.dev.js',
'hk-confg/js/categories.dev.js',
'hk-confg/js/editor.dev.js',
'hk-icerilen/js/tinymce/plugins/wpeditimage/js/editimage.dev.js',
'hk-icerilen/js/tinymce/plugins/wpdialogs/js/popup.dev.js',
'hk-icerilen/js/tinymce/plugins/wpdialogs/js/wpdialog.dev.js',
'hk-icerilen/js/plupload/handlers.dev.js',
'hk-icerilen/js/plupload/wp-plupload.dev.js',
'hk-icerilen/js/swfupload/handlers.dev.js',
'hk-icerilen/js/jcrop/jquery.Jcrop.dev.js',
'hk-icerilen/js/jcrop/jquery.Jcrop.js',
'hk-icerilen/js/jcrop/jquery.Jcrop.css',
'hk-icerilen/js/imgareaselect/jquery.imgareaselect.dev.js',
'hk-icerilen/css/wp-pointer.dev.css',
'hk-icerilen/css/editor.dev.css',
'hk-icerilen/css/jquery-ui-dialog.dev.css',
'hk-icerilen/css/admin-bar-rtl.dev.css',
'hk-icerilen/css/admin-bar.dev.css',
'hk-icerilen/js/jquery/ui/jquery.effects.clip.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.scale.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.blind.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.core.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.shake.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.fade.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.explode.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.slide.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.drop.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.highlight.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.bounce.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.pulsate.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.transfer.min.js',
'hk-icerilen/js/jquery/ui/jquery.effects.fold.min.js',
'hk-confg/images/screenshots/captions-1.png',
'hk-confg/images/screenshots/captions-2.png',
'hk-confg/images/screenshots/flex-header-1.png',
'hk-confg/images/screenshots/flex-header-2.png',
'hk-confg/images/screenshots/flex-header-3.png',
'hk-confg/images/screenshots/flex-header-media-library.png',
'hk-confg/images/screenshots/theme-customizer.png',
'hk-confg/images/screenshots/twitter-embed-1.png',
'hk-confg/images/screenshots/twitter-embed-2.png',
'hk-confg/js/utils.js',
'hk-confg/options-privacy.php',
'wp-app.php',
'hk-icerilen/class-wp-atom-server.php',
'hk-icerilen/js/tinymce/themes/advanced/skins/wp_theme/ui.css',
// 3.5.2
'hk-icerilen/js/swfupload/swfupload-all.js',
// 3.6
'hk-confg/js/revisions-js.php',
'hk-confg/images/screenshots',
'hk-confg/js/categories.js',
'hk-confg/js/categories.min.js',
'hk-confg/js/custom-fields.js',
'hk-confg/js/custom-fields.min.js',
// 3.7
'hk-confg/js/cat.js',
'hk-confg/js/cat.min.js',
'hk-icerilen/js/tinymce/plugins/wpeditimage/js/editimage.min.js',
// 3.8
'hk-icerilen/js/tinymce/themes/advanced/skins/wp_theme/img/page_bug.gif',
'hk-icerilen/js/tinymce/themes/advanced/skins/wp_theme/img/more_bug.gif',
'hk-icerilen/js/thickbox/tb-close-2x.png',
'hk-icerilen/js/thickbox/tb-close.png',
'hk-icerilen/images/wpmini-blue-2x.png',
'hk-icerilen/images/wpmini-blue.png',
'hk-confg/css/colors-fresh.css',
'hk-confg/css/colors-classic.css',
'hk-confg/css/colors-fresh.min.css',
'hk-confg/css/colors-classic.min.css',
'hk-confg/js/about.min.js',
'hk-confg/js/about.js',
'hk-confg/images/arrows-dark-vs-2x.png',
'hk-confg/images/wp-logo-vs.png',
'hk-confg/images/arrows-dark-vs.png',
'hk-confg/images/wp-logo.png',
'hk-confg/images/arrows-pr.png',
'hk-confg/images/arrows-dark.png',
'hk-confg/images/press-this.png',
'hk-confg/images/press-this-2x.png',
'hk-confg/images/arrows-vs-2x.png',
'hk-confg/images/welcome-icons.png',
'hk-confg/images/wp-logo-2x.png',
'hk-confg/images/stars-rtl-2x.png',
'hk-confg/images/arrows-dark-2x.png',
'hk-confg/images/arrows-pr-2x.png',
'hk-confg/images/menu-shadow-rtl.png',
'hk-confg/images/arrows-vs.png',
'hk-confg/images/about-search-2x.png',
'hk-confg/images/bubble_bg-rtl-2x.gif',
'hk-confg/images/wp-badge-2x.png',
'hk-confg/images/wordpress-logo-2x.png',
'hk-confg/images/bubble_bg-rtl.gif',
'hk-confg/images/wp-badge.png',
'hk-confg/images/menu-shadow.png',
'hk-confg/images/about-globe-2x.png',
'hk-confg/images/welcome-icons-2x.png',
'hk-confg/images/stars-rtl.png',
'hk-confg/images/wp-logo-vs-2x.png',
'hk-confg/images/about-updates-2x.png',
// 3.9
'hk-confg/css/colors.css',
'hk-confg/css/colors.min.css',
'hk-confg/css/colors-rtl.css',
'hk-confg/css/colors-rtl.min.css',
'hk-confg/css/media-rtl.min.css',
'hk-confg/css/media.min.css',
'hk-confg/css/farbtastic-rtl.min.css',
'hk-confg/images/lock-2x.png',
'hk-confg/images/lock.png',
'hk-confg/js/theme-preview.js',
'hk-confg/js/theme-install.min.js',
'hk-confg/js/theme-install.js',
'hk-confg/js/theme-preview.min.js',
'hk-icerilen/js/plupload/plupload.html4.js',
'hk-icerilen/js/plupload/plupload.html5.js',
'hk-icerilen/js/plupload/changelog.txt',
'hk-icerilen/js/plupload/plupload.silverlight.js',
'hk-icerilen/js/plupload/plupload.flash.js',
'hk-icerilen/js/plupload/plupload.js',
'hk-icerilen/js/tinymce/plugins/spellchecker',
'hk-icerilen/js/tinymce/plugins/inlinepopups',
'hk-icerilen/js/tinymce/plugins/media/js',
'hk-icerilen/js/tinymce/plugins/media/css',
'hk-icerilen/js/tinymce/plugins/wordpress/img',
'hk-icerilen/js/tinymce/plugins/wpdialogs/js',
'hk-icerilen/js/tinymce/plugins/wpeditimage/img',
'hk-icerilen/js/tinymce/plugins/wpeditimage/js',
'hk-icerilen/js/tinymce/plugins/wpeditimage/css',
'hk-icerilen/js/tinymce/plugins/wpgallery/img',
'hk-icerilen/js/tinymce/plugins/wpfullscreen/css',
'hk-icerilen/js/tinymce/plugins/paste/js',
'hk-icerilen/js/tinymce/themes/advanced',
'hk-icerilen/js/tinymce/tiny_mce.js',
'hk-icerilen/js/tinymce/mark_loaded_src.js',
'hk-icerilen/js/tinymce/wp-tinymce-schema.js',
'hk-icerilen/js/tinymce/plugins/media/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/media/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/media/media.htm',
'hk-icerilen/js/tinymce/plugins/wpview/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/wpview/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/directionality/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/directionality/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/wordpress/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/wordpress/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/wpdialogs/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/wpdialogs/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/wpeditimage/editimage.html',
'hk-icerilen/js/tinymce/plugins/wpeditimage/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/wpeditimage/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/fullscreen/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/fullscreen/fullscreen.htm',
'hk-icerilen/js/tinymce/plugins/fullscreen/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/wplink/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/wplink/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/wpgallery/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/wpgallery/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/tabfocus/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/tabfocus/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/wpfullscreen/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/wpfullscreen/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/paste/editor_plugin.js',
'hk-icerilen/js/tinymce/plugins/paste/pasteword.htm',
'hk-icerilen/js/tinymce/plugins/paste/editor_plugin_src.js',
'hk-icerilen/js/tinymce/plugins/paste/pastetext.htm',
'hk-icerilen/js/tinymce/langs/wp-langs.php',
// 4.1
'hk-icerilen/js/jquery/ui/jquery.ui.accordion.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.autocomplete.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.button.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.core.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.datepicker.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.dialog.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.draggable.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.droppable.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-blind.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-bounce.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-clip.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-drop.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-explode.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-fade.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-fold.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-highlight.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-pulsate.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-scale.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-shake.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-slide.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect-transfer.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.effect.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.menu.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.mouse.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.position.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.progressbar.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.resizable.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.selectable.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.slider.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.sortable.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.spinner.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.tabs.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.tooltip.min.js',
'hk-icerilen/js/jquery/ui/jquery.ui.widget.min.js',
'hk-icerilen/js/tinymce/skins/wordpress/images/dashicon-no-alt.png'
);

/**
 * Stores new files in hk-icerik to copy
 *
 * The contents of this array indicate any new bundled plugins/themes which
 * should be installed with the WordPress Upgrade. These items will not be
 * re-installed in future upgrades, this behaviour is controlled by the
 * introduced version present here being older than the current installed version.
 *
 * The content of this array should follow the following format:
 * Filename (relative to hk-icerikk) => Introduced version
 * Directories should be noted by suffixing it with a trailing slash (/)
 *
 * @since 3.2.0
 * @global array $_new_bundled_files
 * @var array
 * @name $_new_bundled_files
 */
global $_new_bundled_files;

$_new_bundled_files = array(
	'plugins/akismet/'       => '2.0',
	'themes/twentyten/'      => '3.0',
	'themes/twentyeleven/'   => '3.2',
	'themes/twentytwelve/'   => '3.5',
	'themes/twentythirteen/' => '3.6',
	'themes/twentyfourteen/' => '3.8',
	'themes/twentyfifteen/'  => '4.1',
);

/**
 * Upgrade the core of WordPress.
 *
 * This will create a .maintenance file at the base of the WordPress directory
 * to ensure that people can not access the web site, when the files are being
 * copied to their locations.
 *
 * The files in the {@link $_old_files} list will be removed and the new files
 * copied from the zip file after the database is upgraded.
 *
 * The files in the {@link $_new_bundled_files} list will be added to the installation
 * if the version is greater than or equal to the old version being upgraded.
 *
 * The steps for the upgrader for after the new release is downloaded and
 * unzipped is:
 *   1. Test unzipped location for select files to ensure that unzipped worked.
 *   2. Create the .maintenance file in current WordPress base.
 *   3. Copy new WordPress directory over old WordPress files.
 *   4. Upgrade WordPress to new version.
 *     4.1. Copy all files/folders other than hk-icerikk
 *     4.2. Copy any language files to WP_LANG_DIR (which may differ from WP_CONTENT_DIR
 *     4.3. Copy any new bundled themes/plugins to their respective locations
 *   5. Delete new WordPress directory path.
 *   6. Delete .maintenance file.
 *   7. Remove old files.
 *   8. Delete 'update_core' option.
 *
 * There are several areas of failure. For instance if PHP times out before step
 * 6, then you will not be able to access any portion of your site. Also, since
 * the upgrade will not continue where it left off, you will not be able to
 * automatically remove old files and remove the 'update_core' option. This
 * isn't that bad.
 *
 * If the copy of the new WordPress over the old fails, then the worse is that
 * the new WordPress directory will remain.
 *
 * If it is assumed that every file will be copied over, including plugins and
 * themes, then if you edit the default theme, you should rename it, so that
 * your changes remain.
 *
 * @since 2.7.0
 *
 * @param string $from New release unzipped path.
 * @param string $to Path to old WordPress installation.
 * @return WP_Error|null WP_Error on failure, null on success.
 */
function update_core($from, $to) {
	global $wp_filesystem, $_old_files, $_new_bundled_files, $wpdb;

	@set_time_limit( 300 );

	/**
	 * Filter feedback messages displayed during the core update process.
	 *
	 * The filter is first evaluated after the zip file for the latest version
	 * has been downloaded and unzipped. It is evaluated five more times during
	 * the process:
	 *
	 * 1. Before WordPress begins the core upgrade process.
	 * 2. Before Maintenance Mode is enabled.
	 * 3. Before WordPress begins copying over the necessary files.
	 * 4. Before Maintenance Mode is disabled.
	 * 5. Before the database is upgraded.
	 *
	 * @since 2.5.0
	 *
	 * @param string $feedback The core update feedback messages.
	 */
	apply_filters( 'update_feedback', __( 'Verifying the unpacked files&#8230;' ) );

	// Sanity check the unzipped distribution.
	$distro = '';
	$roots = array( '/wordpress/', '/wordpress-mu/' );
	foreach ( $roots as $root ) {
		if ( $wp_filesystem->exists( $from . $root . 'readme.html' ) && $wp_filesystem->exists( $from . $root . 'hk-icerilen/version.php' ) ) {
			$distro = $root;
			break;
		}
	}
	if ( ! $distro ) {
		$wp_filesystem->delete( $from, true );
		return new WP_Error( 'insane_distro', __('The update could not be unpacked') );
	}

	// Import $wp_version, $required_php_version, and $required_mysql_version from the new version
	// $wp_filesystem->wp_content_dir() returned unslashed pre-2.8
	global $wp_version, $required_php_version, $required_mysql_version;

	$versions_file = trailingslashit( $wp_filesystem->wp_content_dir() ) . 'upgrade/version-current.php';
	if ( ! $wp_filesystem->copy( $from . $distro . 'hk-icerilen/version.php', $versions_file ) ) {
		$wp_filesystem->delete( $from, true );
		return new WP_Error( 'copy_failed_for_version_file', __( 'The update cannot be installed because we will be unable to copy some files. This is usually due to inconsistent file permissions.' ), 'hk-icerilen/version.php' );
	}

	$wp_filesystem->chmod( $versions_file, FS_CHMOD_FILE );
	require( WP_CONTENT_DIR . '/upgrade/version-current.php' );
	$wp_filesystem->delete( $versions_file );

	$php_version    = phpversion();
	$mysql_version  = $wpdb->db_version();
	$old_wp_version = $wp_version; // The version of WordPress we're updating from
	$development_build = ( false !== strpos( $old_wp_version . $wp_version, '-' )  ); // a dash in the version indicates a Development release
	$php_compat     = version_compare( $php_version, $required_php_version, '>=' );
	if ( file_exists( WP_CONTENT_DIR . '/db.php' ) && empty( $wpdb->is_mysql ) )
		$mysql_compat = true;
	else
		$mysql_compat = version_compare( $mysql_version, $required_mysql_version, '>=' );

	if ( !$mysql_compat || !$php_compat )
		$wp_filesystem->delete($from, true);

	if ( !$mysql_compat && !$php_compat )
		return new WP_Error( 'php_mysql_not_compatible', sprintf( __('The update cannot be installed because WordPress %1$s requires PHP version %2$s or higher and MySQL version %3$s or higher. You are running PHP version %4$s and MySQL version %5$s.'), $wp_version, $required_php_version, $required_mysql_version, $php_version, $mysql_version ) );
	elseif ( !$php_compat )
		return new WP_Error( 'php_not_compatible', sprintf( __('The update cannot be installed because WordPress %1$s requires PHP version %2$s or higher. You are running version %3$s.'), $wp_version, $required_php_version, $php_version ) );
	elseif ( !$mysql_compat )
		return new WP_Error( 'mysql_not_compatible', sprintf( __('The update cannot be installed because WordPress %1$s requires MySQL version %2$s or higher. You are running version %3$s.'), $wp_version, $required_mysql_version, $mysql_version ) );

	/** This filter is documented in hk-confg/includes/update-core.php */
	apply_filters( 'update_feedback', __( 'Preparing to install the latest version&#8230;' ) );

	// Don't copy hk-icerik, we'll deal with that below
	// We also copy version.php last so failed updates report their old version
	$skip = array( 'hk-icerikk', 'hk-icerilen/version.php' );
	$check_is_writable = array();

	// Check to see which files don't really need updating - only available for 3.7 and higher
	if ( function_exists( 'get_core_checksums' ) ) {
		// Find the local version of the working directory
		$working_dir_local = WP_CONTENT_DIR . '/upgrade/' . basename( $from ) . $distro;

		$checksums = get_core_checksums( $wp_version, isset( $wp_local_package ) ? $wp_local_package : 'en_US' );
		if ( is_array( $checksums ) && isset( $checksums[ $wp_version ] ) )
			$checksums = $checksums[ $wp_version ]; // Compat code for 3.7-beta2
		if ( is_array( $checksums ) ) {
			foreach( $checksums as $file => $checksum ) {
				if ( 'hk-icerikk' == substr( $file, 0, 10 ) )
					continue;
				if ( ! file_exists( ABSPATH . $file ) )
					continue;
				if ( ! file_exists( $working_dir_local . $file ) )
					continue;
				if ( md5_file( ABSPATH . $file ) === $checksum )
					$skip[] = $file;
				else
					$check_is_writable[ $file ] = ABSPATH . $file;
			}
		}
	}

	// If we're using the direct method, we can predict write failures that are due to permissions.
	if ( $check_is_writable && 'direct' === $wp_filesystem->method ) {
		$files_writable = array_filter( $check_is_writable, array( $wp_filesystem, 'is_writable' ) );
		if ( $files_writable !== $check_is_writable ) {
			$files_not_writable = array_diff_key( $check_is_writable, $files_writable );
			foreach ( $files_not_writable as $relative_file_not_writable => $file_not_writable ) {
				// If the writable check failed, chmod file to 0644 and try again, same as copy_dir().
				$wp_filesystem->chmod( $file_not_writable, FS_CHMOD_FILE );
				if ( $wp_filesystem->is_writable( $file_not_writable ) )
					unset( $files_not_writable[ $relative_file_not_writable ] );
			}

			// Store package-relative paths (the key) of non-writable files in the WP_Error object.
			$error_data = version_compare( $old_wp_version, '3.7-beta2', '>' ) ? array_keys( $files_not_writable ) : '';

			if ( $files_not_writable )
				return new WP_Error( 'files_not_writable', __( 'The update cannot be installed because we will be unable to copy some files. This is usually due to inconsistent file permissions.' ), implode( ', ', $error_data ) );
		}
	}

	/** This filter is documented in hk-confg/includes/update-core.php */
	apply_filters( 'update_feedback', __( 'Enabling Maintenance mode&#8230;' ) );
	// Create maintenance file to signal that we are upgrading
	$maintenance_string = '<?php $upgrading = ' . time() . '; ?>';
	$maintenance_file = $to . '.maintenance';
	$wp_filesystem->delete($maintenance_file);
	$wp_filesystem->put_contents($maintenance_file, $maintenance_string, FS_CHMOD_FILE);

	/** This filter is documented in hk-confg/includes/update-core.php */
	apply_filters( 'update_feedback', __( 'Copying the required files&#8230;' ) );
	// Copy new versions of WP files into place.
	$result = _copy_dir( $from . $distro, $to, $skip );
	if ( is_wp_error( $result ) )
		$result = new WP_Error( $result->get_error_code(), $result->get_error_message(), substr( $result->get_error_data(), strlen( $to ) ) );

	// Since we know the core files have copied over, we can now copy the version file
	if ( ! is_wp_error( $result ) ) {
		if ( ! $wp_filesystem->copy( $from . $distro . 'hk-icerilen/version.php', $to . 'hk-icerilen/version.php', true /* overwrite */ ) ) {
			$wp_filesystem->delete( $from, true );
			$result = new WP_Error( 'copy_failed_for_version_file', __( 'The update cannot be installed because we will be unable to copy some files. This is usually due to inconsistent file permissions.' ), 'hk-icerilen/version.php' );
		}
		$wp_filesystem->chmod( $to . 'hk-icerilen/version.php', FS_CHMOD_FILE );
	}

	// Check to make sure everything copied correctly, ignoring the contents of hk-icerikk
	$skip = array( 'hk-icerikk' );
	$failed = array();
	if ( isset( $checksums ) && is_array( $checksums ) ) {
		foreach ( $checksums as $file => $checksum ) {
			if ( 'hk-icerikk' == substr( $file, 0, 10 ) )
				continue;
			if ( ! file_exists( $working_dir_local . $file ) )
				continue;
			if ( file_exists( ABSPATH . $file ) && md5_file( ABSPATH . $file ) == $checksum )
				$skip[] = $file;
			else
				$failed[] = $file;
		}
	}

	// Some files didn't copy properly
	if ( ! empty( $failed ) ) {
		$total_size = 0;
		foreach ( $failed as $file ) {
			if ( file_exists( $working_dir_local . $file ) )
				$total_size += filesize( $working_dir_local . $file );
		}

		// If we don't have enough free space, it isn't worth trying again.
		// Unlikely to be hit due to the check in unzip_file().
		$available_space = @disk_free_space( ABSPATH );
		if ( $available_space && $total_size >= $available_space ) {
			$result = new WP_Error( 'disk_full', __( 'There is not enough free disk space to complete the update.' ) );
		} else {
			$result = _copy_dir( $from . $distro, $to, $skip );
			if ( is_wp_error( $result ) )
				$result = new WP_Error( $result->get_error_code() . '_retry', $result->get_error_message(), substr( $result->get_error_data(), strlen( $to ) ) );
		}
	}

	// Custom Content Directory needs updating now.
	// Copy Languages
	if ( !is_wp_error($result) && $wp_filesystem->is_dir($from . $distro . 'hk-icerikk/languages') ) {
		if ( WP_LANG_DIR != ABSPATH . WPINC . '/languages' || @is_dir(WP_LANG_DIR) )
			$lang_dir = WP_LANG_DIR;
		else
			$lang_dir = WP_CONTENT_DIR . '/languages';

		if ( !@is_dir($lang_dir) && 0 === strpos($lang_dir, ABSPATH) ) { // Check the language directory exists first
			$wp_filesystem->mkdir($to . str_replace(ABSPATH, '', $lang_dir), FS_CHMOD_DIR); // If it's within the ABSPATH we can handle it here, otherwise they're out of luck.
			clearstatcache(); // for FTP, Need to clear the stat cache
		}

		if ( @is_dir($lang_dir) ) {
			$wp_lang_dir = $wp_filesystem->find_folder($lang_dir);
			if ( $wp_lang_dir ) {
				$result = copy_dir($from . $distro . 'hk-icerikk/languages/', $wp_lang_dir);
				if ( is_wp_error( $result ) )
					$result = new WP_Error( $result->get_error_code() . '_languages', $result->get_error_message(), substr( $result->get_error_data(), strlen( $wp_lang_dir ) ) );
			}
		}
	}

	/** This filter is documented in hk-confg/includes/update-core.php */
	apply_filters( 'update_feedback', __( 'Disabling Maintenance mode&#8230;' ) );
	// Remove maintenance file, we're done with potential site-breaking changes
	$wp_filesystem->delete( $maintenance_file );

	// 3.5 -> 3.5+ - an empty twentytwelve directory was created upon upgrade to 3.5 for some users, preventing installation of Twenty Twelve.
	if ( '3.5' == $old_wp_version ) {
		if ( is_dir( WP_CONTENT_DIR . '/themes/twentytwelve' ) && ! file_exists( WP_CONTENT_DIR . '/themes/twentytwelve/style.css' )  ) {
			$wp_filesystem->delete( $wp_filesystem->wp_themes_dir() . 'twentytwelve/' );
		}
	}

	// Copy New bundled plugins & themes
	// This gives us the ability to install new plugins & themes bundled with future versions of WordPress whilst avoiding the re-install upon upgrade issue.
	// $development_build controls us overwriting bundled themes and plugins when a non-stable release is being updated
	if ( !is_wp_error($result) && ( ! defined('CORE_UPGRADE_SKIP_NEW_BUNDLED') || ! CORE_UPGRADE_SKIP_NEW_BUNDLED ) ) {
		foreach ( (array) $_new_bundled_files as $file => $introduced_version ) {
			// If a $development_build or if $introduced version is greater than what the site was previously running
			if ( $development_build || version_compare( $introduced_version, $old_wp_version, '>' ) ) {
				$directory = ('/' == $file[ strlen($file)-1 ]);
				list($type, $filename) = explode('/', $file, 2);

				// Check to see if the bundled items exist before attempting to copy them
				if ( ! $wp_filesystem->exists( $from . $distro . 'hk-icerikk/' . $file ) )
					continue;

				if ( 'plugins' == $type )
					$dest = $wp_filesystem->wp_plugins_dir();
				elseif ( 'themes' == $type )
					$dest = trailingslashit($wp_filesystem->wp_themes_dir()); // Back-compat, ::wp_themes_dir() did not return trailingslash'd pre-3.2
				else
					continue;

				if ( ! $directory ) {
					if ( ! $development_build && $wp_filesystem->exists( $dest . $filename ) )
						continue;

					if ( ! $wp_filesystem->copy($from . $distro . 'hk-icerikk/' . $file, $dest . $filename, FS_CHMOD_FILE) )
						$result = new WP_Error( "copy_failed_for_new_bundled_$type", __( 'Could not copy file.' ), $dest . $filename );
				} else {
					if ( ! $development_build && $wp_filesystem->is_dir( $dest . $filename ) )
						continue;

					$wp_filesystem->mkdir($dest . $filename, FS_CHMOD_DIR);
					$_result = copy_dir( $from . $distro . 'hk-icerikk/' . $file, $dest . $filename);

					// If a error occurs partway through this final step, keep the error flowing through, but keep process going.
					if ( is_wp_error( $_result ) ) {
						if ( ! is_wp_error( $result ) )
							$result = new WP_Error;
						$result->add( $_result->get_error_code() . "_$type", $_result->get_error_message(), substr( $_result->get_error_data(), strlen( $dest ) ) );
					}
				}
			}
		} //end foreach
	}

	// Handle $result error from the above blocks
	if ( is_wp_error($result) ) {
		$wp_filesystem->delete($from, true);
		return $result;
	}

	// Remove old files
	foreach ( $_old_files as $old_file ) {
		$old_file = $to . $old_file;
		if ( !$wp_filesystem->exists($old_file) )
			continue;
		$wp_filesystem->delete($old_file, true);
	}

	// Remove any Genericons example.html's from the filesystem
	_upgrade_422_remove_genericons();

	// Upgrade DB with separate request
	/** This filter is documented in hk-confg/includes/update-core.php */
	apply_filters( 'update_feedback', __( 'Upgrading database&#8230;' ) );
	$db_upgrade_url = admin_url('upgrade.php?step=upgrade_db');
	wp_remote_post($db_upgrade_url, array('timeout' => 60));

	// Clear the cache to prevent an update_option() from saving a stale db_version to the cache
	wp_cache_flush();
	// (Not all cache backends listen to 'flush')
	wp_cache_delete( 'alloptions', 'options' );

	// Remove working directory
	$wp_filesystem->delete($from, true);

	// Force refresh of update information
	if ( function_exists('delete_site_transient') )
		delete_site_transient('update_core');
	else
		delete_option('update_core');

	/**
	 * Fires after WordPress core has been successfully updated.
	 *
	 * @since 3.3.0
	 *
	 * @param string $wp_version The current WordPress version.
	 */
	do_action( '_core_updated_successfully', $wp_version );

	// Clear the option that blocks auto updates after failures, now that we've been successful.
	if ( function_exists( 'delete_site_option' ) )
		delete_site_option( 'auto_core_update_failed' );

	return $wp_version;
}

/**
 * Copies a directory from one location to another via the WordPress Filesystem Abstraction.
 * Assumes that WP_Filesystem() has already been called and setup.
 *
 * This is a temporary function for the 3.1 -> 3.2 upgrade, as well as for those upgrading to
 * 3.7+
 *
 * @ignore
 * @since 3.2.0
 * @since 3.7.0 Updated not to use a regular expression for the skip list
 * @see copy_dir()
 *
 * @param string $from source directory
 * @param string $to destination directory
 * @param array $skip_list a list of files/folders to skip copying
 * @return mixed WP_Error on failure, True on success.
 */
function _copy_dir($from, $to, $skip_list = array() ) {
	global $wp_filesystem;

	$dirlist = $wp_filesystem->dirlist($from);

	$from = trailingslashit($from);
	$to = trailingslashit($to);

	foreach ( (array) $dirlist as $filename => $fileinfo ) {
		if ( in_array( $filename, $skip_list ) )
			continue;

		if ( 'f' == $fileinfo['type'] ) {
			if ( ! $wp_filesystem->copy($from . $filename, $to . $filename, true, FS_CHMOD_FILE) ) {
				// If copy failed, chmod file to 0644 and try again.
				$wp_filesystem->chmod( $to . $filename, FS_CHMOD_FILE );
				if ( ! $wp_filesystem->copy($from . $filename, $to . $filename, true, FS_CHMOD_FILE) )
					return new WP_Error( 'copy_failed__copy_dir', __( 'Could not copy file.' ), $to . $filename );
			}
		} elseif ( 'd' == $fileinfo['type'] ) {
			if ( !$wp_filesystem->is_dir($to . $filename) ) {
				if ( !$wp_filesystem->mkdir($to . $filename, FS_CHMOD_DIR) )
					return new WP_Error( 'mkdir_failed__copy_dir', __( 'Could not create directory.' ), $to . $filename );
			}

			/*
			 * Generate the $sub_skip_list for the subdirectory as a sub-set
			 * of the existing $skip_list.
			 */
			$sub_skip_list = array();
			foreach ( $skip_list as $skip_item ) {
				if ( 0 === strpos( $skip_item, $filename . '/' ) )
					$sub_skip_list[] = preg_replace( '!^' . preg_quote( $filename, '!' ) . '/!i', '', $skip_item );
			}

			$result = _copy_dir($from . $filename, $to . $filename, $sub_skip_list);
			if ( is_wp_error($result) )
				return $result;
		}
	}
	return true;
}

/**
 * Redirect to the About WordPress page after a successful upgrade.
 *
 * This function is only needed when the existing install is older than 3.4.0.
 *
 * @since 3.3.0
 *
 */
function _redirect_to_about_wordpress( $new_version ) {
	global $wp_version, $pagenow, $action;

	if ( version_compare( $wp_version, '3.4-RC1', '>=' ) )
		return;

	// Ensure we only run this on the update-core.php page. The Core_Upgrader may be used in other contexts.
	if ( 'update-core.php' != $pagenow )
		return;

 	if ( 'do-core-upgrade' != $action && 'do-core-reinstall' != $action )
 		return;

	// Load the updated default text localization domain for new strings.
	load_default_textdomain();

	// See do_core_upgrade()
	show_message( __('WordPress updated successfully') );

	// self_admin_url() won't exist when upgrading from <= 3.0, so relative URLs are intentional.
	show_message( '<span class="hide-if-no-js">' . sprintf( __( 'Welcome to WordPress %1$s. You will be redirected to the About WordPress screen. If not, click <a href="%2$s">here</a>.' ), $new_version, 'about.php?updated' ) . '</span>' );
	show_message( '<span class="hide-if-js">' . sprintf( __( 'Welcome to WordPress %1$s. <a href="%2$s">Learn more</a>.' ), $new_version, 'about.php?updated' ) . '</span>' );
	echo '</div>';
	?>
<script type="text/javascript">
window.location = 'about.php?updated';
</script>
	<?php

	// Include admin-footer.php and exit.
	include(ABSPATH . 'hk-confg/admin-footer.php');
	exit();
}
add_action( '_core_updated_successfully', '_redirect_to_about_wordpress' );

/**
 * Cleans up Genericons example files.
 *
 * @since 4.2.2
 */
function _upgrade_422_remove_genericons() {
	global $wp_theme_directories, $wp_filesystem;

	// A list of the affected files using the filesystem absolute paths.
	$affected_files = array();

	// Themes
	foreach ( $wp_theme_directories as $directory ) {
		$affected_theme_files = _upgrade_422_find_genericons_files_in_folder( $directory );
		$affected_files       = array_merge( $affected_files, $affected_theme_files );
	}

	// Plugins
	$affected_plugin_files = _upgrade_422_find_genericons_files_in_folder( WP_PLUGIN_DIR );
	$affected_files        = array_merge( $affected_files, $affected_plugin_files );

	foreach ( $affected_files as $file ) {
		$gen_dir = $wp_filesystem->find_folder( trailingslashit( dirname( $file ) ) );
		if ( empty( $gen_dir ) ) {
			continue;
		}

		// The path when the file is accessed via WP_Filesystem may differ in the case of FTP
		$remote_file = $gen_dir . basename( $file );

		if ( ! $wp_filesystem->exists( $remote_file ) ) {
			continue;
		}

		if ( ! $wp_filesystem->delete( $remote_file, false, 'f' ) ) {
			$wp_filesystem->put_contents( $remote_file, '' );
		}
	}
}

/**
 * Recursively find Genericons example files in a given folder.
 *
 * @ignore
 * @since 4.2.2
 *
 * @param string $directory Directory path. Expects trailingslashed.
 * @return array
 */
function _upgrade_422_find_genericons_files_in_folder( $directory ) {
	$directory = trailingslashit( $directory );
	$files     = array();

	if ( file_exists( "{$directory}example.html" ) && false !== strpos( file_get_contents( "{$directory}example.html" ), '<title>Genericons</title>' ) ) {
		$files[] = "{$directory}example.html";
	}

	foreach ( glob( $directory . '*', GLOB_ONLYDIR ) as $dir ) {
		$files = array_merge( $files, _upgrade_422_find_genericons_files_in_folder( $dir ) );
	}

	return $files;
}
